CREATE TABLE closet (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    category VARCHAR(255) NOT NULL,
    quantity INT DEFAULT 0,
    amount DECIMAL(10, 2) DEFAULT 0.00,
    price DECIMAL(10, 2) DEFAULT 0.00
);

-- Jeans
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Jeans Size 26', 'Jeans', NULL, 1, 1000),
('Jeans Size 27', 'Jeans', NULL, 30, 1000),
('Jeans Size 28', 'Jeans', NULL, 26, 1000),
('Jeans Size 30', 'Jeans', NULL, 18, 1000),
('Jeans Size 32', 'Jeans', NULL, 21, 1000),
('Jeans Size 34', 'Jeans', NULL, 11, 1000),
('Jeans Size 36', 'Jeans', NULL, 2, 1000);

-- Hipstar
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Hipstar Size 27', 'Hipstar', NULL, 1, 1300),
('Hipstar Size 28', 'Hipstar', NULL, 4, 1300),
('Hipstar Size 30', 'Hipstar', NULL, 0, 1300),
('Hipstar Size 32', 'Hipstar', NULL, 2, 1300),
('Hipstar Size 36', 'Hipstar', NULL, 0, 1300);

-- Mummy Jeans
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Mummy Jeans Size 27', 'Mummy Jeans', NULL, 0, 1500),
('Mummy Jeans Size 28', 'Mummy Jeans', NULL, 5, 1500),
('Mummy Jeans Size 30', 'Mummy Jeans', NULL, 2, 1500),
('Mummy Jeans Size 32', 'Mummy Jeans', NULL, 1, 1500),
('Mummy Jeans Size 34', 'Mummy Jeans', NULL, 3, 1500),
('Mummy Jeans Size 36', 'Mummy Jeans', NULL, 0, 1500);

-- Cargo Pants
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Cargo Pants Size 27', 'Cargo Pants', NULL, 8, 1500),
('Cargo Pants Size 28', 'Cargo Pants', NULL, 5, 1500),
('Cargo Pants Size 30', 'Cargo Pants', NULL, 3, 1500),
('Cargo Pants Size 32', 'Cargo Pants', NULL, 7, 1500),
('Cargo Pants Size 34', 'Cargo Pants', NULL, 14, 1500),
('Cargo Pants Size 36', 'Cargo Pants', NULL, 0, 1500);

-- Slim Girls
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Slim Girls Size 27', 'Slim Girls', NULL, 17, 800),
('Slim Girls Size 28', 'Slim Girls', NULL, 13, 800),
('Slim Girls Size 30', 'Slim Girls', NULL, 12, 800),
('Slim Girls Size 32', 'Slim Girls', NULL, 1, 800),
('Slim Girls Size 34', 'Slim Girls', NULL, 4, 800),
('Slim Girls Size 36', 'Slim Girls', NULL, 0, 800);

-- Baggy with Tack Trouser
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Baggy with Tack Trouser Size 27', 'Baggy with Tack Trouser', NULL, 1, 1500),
('Baggy with Tack Trouser Size 28', 'Baggy with Tack Trouser', NULL, 1, 1500),
('Baggy with Tack Trouser Size 30', 'Baggy with Tack Trouser', NULL, 2, 1500),
('Baggy with Tack Trouser Size 32', 'Baggy with Tack Trouser', NULL, 1, 1500),
('Baggy with Tack Trouser Size 34', 'Baggy with Tack Trouser', NULL, 0, 1500),
('Baggy with Tack Trouser Size 36', 'Baggy with Tack Trouser', NULL, 0, 1500);

-- Lotion
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Amara for Men', 'Lotion', 100, NULL, NULL),
('Amara for Men', 'Lotion', 200, 1, 160),
('Amara for Men', 'Lotion', 400, 1, 250),
('Amara for Men', 'Lotion', 600, NULL, NULL),
('Amara Raw Shea', 'Lotion', 100, NULL, NULL),
('Amara Raw Shea', 'Lotion', 200, NULL, NULL),
('Amara Raw Shea', 'Lotion', 400, NULL, NULL),
('Amara Raw Shea', 'Lotion', 600, 1, 400),
('Vaseline', 'Lotion', 100, NULL, NULL),
('Vaseline', 'Lotion', 200, 2, 350),
('Vaseline', 'Lotion', 400, 1, 550),
('Vaseline', 'Lotion', 600, NULL, NULL),
('Clere Triple Glycerine', 'Lotion', 100, NULL, NULL),
('Clere Triple Glycerine', 'Lotion', 200, 1, 180),
('Clere Triple Glycerine', 'Lotion', 400, 2, 250),
('Clere Triple Glycerine', 'Lotion', 600, NULL, NULL),
('Clere Fire', 'Lotion', 100, NULL, NULL),
('Clere Fire', 'Lotion', 200, 1, 180),
('Clere Fire', 'Lotion', 400, 1, 250),
('Clere Fire', 'Lotion', 600, NULL, NULL),
('Clere Nourishing', 'Lotion', 100, NULL, NULL),
('Clere Nourishing', 'Lotion', 200, 2, 180),
('Clere Nourishing', 'Lotion', 400, NULL, NULL),
('Clere Nourishing', 'Lotion', 600, NULL, NULL),
('Venus Active', 'Lotion', 100, NULL, NULL),
('Venus Active', 'Lotion', 200, NULL, NULL),
('Venus Active', 'Lotion', 400, 1, 420),
('Venus Active', 'Lotion', 600, NULL, NULL),
('Venus Moroccan Argan Oil', 'Lotion', 100, NULL, NULL),
('Venus Moroccan Argan Oil', 'Lotion', 200, NULL, NULL),
('Venus Moroccan Argan Oil', 'Lotion', 400, 1, 420),
('Venus Moroccan Argan Oil', 'Lotion', 600, NULL, NULL),
('Venus Smoothing Vitamin E', 'Lotion', 100, NULL, NULL),
('Venus Smoothing Vitamin E', 'Lotion', 200, NULL, NULL),
('Venus Smoothing Vitamin E', 'Lotion', 400, 1, 420),
('Venus Smoothing Vitamin E', 'Lotion', 600, NULL, NULL),
('Nivea Cocoa', 'Lotion', 100, NULL, NULL),
('Nivea Cocoa', 'Lotion', 200, 1, 400),
('Nivea Cocoa', 'Lotion', 400, 2, 600),
('Nivea Cocoa', 'Lotion', 600, NULL, NULL),
('Nivea Shea Smooth', 'Lotion', 100, NULL, NULL),
('Nivea Shea Smooth', 'Lotion', 200, NULL, NULL),
('Nivea Shea Smooth', 'Lotion', 400, 1, 600),
('Nivea Shea Smooth', 'Lotion', 600, NULL, NULL),
('Nivea Body Milk', 'Lotion', 100, NULL, NULL),
('Nivea Body Milk', 'Lotion', 200, NULL, NULL),
('Nivea Body Milk', 'Lotion', 400, 1, 600),
('Nivea Body Milk', 'Lotion', 600, NULL, NULL),
('Nivea Men', 'Lotion', 100, NULL, NULL),
('Nivea Men', 'Lotion', 200, 1, 350),
('Nivea Men', 'Lotion', 400, NULL, NULL),
('Nivea Men', 'Lotion', 600, NULL, NULL),
('Nice and Lovely Aloe Vera', 'Lotion', 100, NULL, NULL),
('Nice and Lovely Aloe Vera', 'Lotion', 200, NULL, NULL),
('Nice and Lovely Aloe Vera', 'Lotion', 400, 1, 300),
('Nice and Lovely Aloe Vera', 'Lotion', 600, 1, 450),
('Nice and Lovely Glycerine', 'Lotion', 100, NULL, NULL),
('Nice and Lovely Glycerine', 'Lotion', 200, NULL, NULL),
('Nice and Lovely Glycerine', 'Lotion', 400, 1, 300),
('Nice and Lovely Glycerine', 'Lotion', 600, 1, 450),
('Nice and Lovely Cocoa Butter', 'Lotion', 100, NULL, NULL),
('Nice and Lovely Cocoa Butter', 'Lotion', 200, NULL, NULL),
('Nice and Lovely Cocoa Butter', 'Lotion', 400, NULL, NULL),
('Nice and Lovely Cocoa Butter', 'Lotion', 600, 1, 450),
('Nice and Lovely Lemon', 'Lotion', 180, 3, 200),
('Nice and Lovely Lemon', 'Lotion', 360, 2, 320),
('Nice and Lovely Lemon', 'Lotion', 720, NULL, NULL);

-- Glycerine
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Velous', 'Glycerine', 30, 7, 50),
('Body luxe', 'Glycerine', 50, 4, 60),
('Stretch mark remover', 'Glycerine', 250, 1, NULL);

-- Oil
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Paw paw', 'Oil', 300, NULL, 500),
('Ideal olive oil', 'Oil', 25, 1, 150),
('Ideal olive oil', 'Oil', 50, 2, 250),
('Ideal olive oil', 'Oil', 100, 1, 400),
('Ideal olive oil', 'Oil', 200, 1, 600);

-- Body Splash
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Sweet vanilla', 'Body Splash', 59, 1, 150),
('Sweet vanilla', 'Body Splash', 236, NULL, NULL),
('Cherry blossom', 'Body Splash', 59, NULL, NULL),
('Cherry blossom', 'Body Splash', 236, 1, 300),
('Warm night', 'Body Splash', 59, 1, 150),
('Warm night', 'Body Splash', 236, NULL, NULL),
('Noir', 'Body Splash', 59, 1, 150),
('Noir', 'Body Splash', 236, NULL, NULL),
('Wild night', 'Body Splash', 59, 1, 150),
('Wild night', 'Body Splash', 236, NULL, NULL),
('Wonderful day', 'Body Splash', 236, 1, 300),
('Wonderful day', 'Body Splash', 59, NULL, NULL),
('Poisonous kiss', 'Body Splash', 236, 0, 300),
('Poisonous kiss', 'Body Splash', NULL, NULL, NULL);

-- Canned Body Splash
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Innocence', 'Canned Body Splash', 200, 1, 400),
('Secret', 'Canned Body Splash', 200, 1, 400),
('Blue lady', 'Canned Body Splash', 200, 1, 400),
('Chastity', 'Canned Body Splash', 200, 3, 400);

-- Deodorant Canned
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Nivea natural fresh', 'Deodorant Canned', 150, 1, 600),
('Nivea protect and care', 'Deodorant Canned', 150, 2, 600),
('Nivea deep impact', 'Deodorant Canned', 150, 1, 600);

-- Roll On
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Rexona powder dry', 'Roll On', 25, 4, 180),
('Rexona quantum dry', 'Roll On', 25, 1, 189),
('Rexona cotton dry', 'Roll On', 25, 1, 180),
('La divas bella', 'Roll On', 60, 1, NULL),
('Dove beauty finish', 'Roll On', 50, 1, 350),
('Nivea dry impact', 'Roll On', 50, 2, 380),
('Nivea double effect', 'Roll On', 50, 3, 380),
('Nivea cool kick', 'Roll On', 50, 1, 380),
('Nivea dry comfort', 'Roll On', 50, 1, 380),
('Nivea black and white', 'Roll On', 50, 0, 380),
('Nivea fresh active', 'Roll On', 50, 2, 380),
('Nivea deep', 'Roll On', 50, 2, 380);

-- Spirit
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Surgical spirit', 'Spirit', 50, 2, 100);

-- Cutex
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Cutex big', 'Cutex', NULL, 12, 50),
('Cutex small', 'Cutex', NULL, 22, 30),
('Cutex remover', 'Cutex', 30, 2, 50);

-- Spray Bottle
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Fancy spray bottle', 'Spray Bottle', NULL, 6, 150),
('Fancy spray bottle', 'Spray Bottle', NULL, 1, 200);

-- Highlighter
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Saronis', 'Highlighter', 12, 4, 100);

-- Hair Dye
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Dexe', 'Hair Dye', NULL, 0, 50),
('Radiant', 'Hair Dye', 25, 1, NULL),
('Radiant', 'Hair Dye', 120, NULL, 250),
('Movit', 'Hair Dye', 85, 2, 200),
('Movit', 'Hair Dye', 120, 1, 250),
('Subaru gold', 'Hair Dye', NULL, 3, 100),
('Subaru gold coral', 'Hair Dye', NULL, 2, 100),
('Subaru grape red', 'Hair Dye', NULL, 1, 100);

-- Massage Oil
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Strawberry oils', 'Massage Oil', 500, 1, 300),
('Cool mint oils', 'Massage Oil', 500, 1, 300),
('Almond oils', 'Massage Oil', 500, 1, 300),
('Eucalyptus', 'Massage Oil', 500, 1, 300);

-- Smart Collection Spray
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Black opium', 'Smart Collection Spray', 15, 1, 150),
('One million', 'Smart Collection Spray', 15, 0, 150),
('Polo sport', 'Smart Collection Spray', 15, 1, 150),
('Hugo boss', 'Smart Collection Spray', 15, 0, 150),
('Chelsea', 'Smart Collection Spray', 35, 7, 250),
('Blue de chinele', 'Smart Collection Spray', NULL, 1, 500),
('Scentuals', 'Smart Collection Spray', 100, 1, 500),
('Cool girl', 'Smart Collection Spray', 100, 2, 500),
('Dunhill red', 'Smart Collection Spray', 100, 0, 550),
('Don carlos', 'Smart Collection Spray', 100, 2, 500),
('Sabaya', 'Smart Collection Spray', 50, 1, 250),
('Black market', 'Smart Collection Spray', 35, 1, 500),
('Black rayan', 'Smart Collection Spray', 100, 4, 250),
('Hugo ladies', 'Smart Collection Spray', 100, 2, 500),
('Invictus', 'Smart Collection Spray', NULL, 2, 500);

-- Ponds
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Rose leaf', 'Ponds', 23, 1, 150),
('Rose leaf', 'Ponds', 8, 1, 100),
('Rose leaf', 'Ponds', 10, 2, 80),
('A face', 'Ponds', 16, 2, 100);

-- Personal Care
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Toothpicks', 'Personal Care', NULL, 2, 100),
('Nail cutter', 'Personal Care', NULL, 5, 100),
('Henna shugun', 'Personal Care', NULL, 1, NULL),
('Cotton wool', 'Personal Care', 50, 1, 100),
('Kotex panty liner', 'Personal Care', NULL, 2, 250),
('Skin touch masque', 'Personal Care', 170, 1, 250),
('Smart watch', 'Personal Care', NULL, 1, 2000),
('Bella wipes', 'Personal Care', NULL, 2, 200),
('Sungura tissue', 'Personal Care', NULL, 0, 20),
('Soft care pads', 'Personal Care', NULL, 0, 80),
('Cotton ear bud', 'Personal Care', 12, 20, NULL),
('Leg file', 'Personal Care', NULL, 1, 200),
('Hand kit', 'Personal Care', NULL, 1, 300),
('Leg kit', 'Personal Care', NULL, 1, 300);

-- Teddy Bear
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Medium Teddy Bear', 'Teddy Bear', NULL, 3, 1500),
('Small Teddy Bear', 'Teddy Bear', NULL, 1, 1000);

-- Vaseline
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Cocoa butter', 'Vaseline', 240, 1, 400),
('Cocoa butter', 'Vaseline', 95, 0, 200),
('For men', 'Vaseline', 240, 1, 400);

-- Hair Extension
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Big size', 'Hair Extension', NULL, 1, NULL),
('Small', 'Hair Extension', NULL, 1, NULL),
('Medium', 'Hair Extension', NULL, 1, NULL);

-- Box
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Gift box', 'Box', NULL, 3, 200);

-- Air Freshener
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Jasmine', 'Air Freshener', 360, 1, 200),
('Lemon', 'Air Freshener', 360, 0, 200),
('Strawberry', 'Air Freshener', 360, 0, 200),
('Lavender floral', 'Air Freshener', 360, 0, 200),
('Cocktail', 'Air Freshener', 360, 1, 200);

-- Foam Cleaner
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Foam cleaner', 'Foam Cleaner', 650, 2, 500);

-- Shower Gel
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Aloe', 'Shower Gel', 1380, 1, 600),
('Rose', 'Shower Gel', 1380, 1, 600);

-- Gift Wrappers
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Purple', 'Gift Wrappers', NULL, 7, 20),
('Blue', 'Gift Wrappers', NULL, 3, 20),
('Pink', 'Gift Wrappers', NULL, 10, 20);

-- Hair Products
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Bamsi conditioner', 'Hair Products', 500, 1, 400),
('Bamsi shampoo', 'Hair Products', 500, 1, 400),
('Baby care oil', 'Hair Products', 100, 7, 100),
('Movit curl activator', 'Hair Products', 80, 6, 60),
('Bamsi hair food', 'Hair Products', 50, 3, 70),
('Bamsi wax', 'Hair Products', 140, 4, NULL),
('Movit hair relaxer', 'Hair Products', 150, 3, NULL),
('Movit styling hair gel', 'Hair Products', 150, 4, 180),
('Soft&free', 'Hair Products', 125, 0, 170),
('Venus curl activator', 'Hair Products', 50, 2, NULL),
('Bamsi baby love', 'Hair Products', 250, 1, 200),
('Movit blow out cream', 'Hair Products', 150, 6, 150),
('Moulding gel wax', 'Hair Products', 125, 6, 400);

-- Coconut Oil
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Sultan', 'Coconut Oil', 70, 5, 70),
('Sultan', 'Coconut Oil', 150, 5, 100);

-- Miscellaneous Items
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Baby school beads', 'Miscellaneous', NULL, 3, 50),
('Baby powder', 'Miscellaneous', NULL, 6, 50),
('LED light', 'Miscellaneous', NULL, 1, 300),
('Sunshine scrub', 'Miscellaneous', NULL, 9, 100),
('Wokali black mask', 'Miscellaneous', NULL, 1, NULL),
('Bow tie', 'Miscellaneous', NULL, 1, 300),
('Lipstick', 'Miscellaneous', NULL, 17, 150),
('Veet', 'Miscellaneous', 3, 1, 350),
('Nail glue', 'Miscellaneous', 7, 5, 50),
('Vaseline lip gloss', 'Miscellaneous', 14, 2, 50),
('Absolute look lip gloss', 'Miscellaneous', NULL, 4, 50),
('Magic lip gloss', 'Miscellaneous', NULL, 10, 50),
('Squueze and shine lip gloss', 'Miscellaneous', NULL, 4, 50),
('Miss look lip gloss', 'Miscellaneous', NULL, 1, 200),
('3in1 toothbrush', 'Miscellaneous', NULL, 1, 200),
('Nylon fibre toothbrush', 'Miscellaneous', NULL, 6, 50),
('Huda beauty lash glue', 'Miscellaneous', NULL, 2, 1000),
('Women ice bracelet', 'Miscellaneous', NULL, 8, 100),
('Bracelet-bead', 'Miscellaneous', NULL, 4, 50),
('Arm ornaments', 'Miscellaneous', NULL, 5, 200),
('Ice pendant', 'Miscellaneous', NULL, 2, 100),
('Hand brush', 'Miscellaneous', NULL, NULL, 150),
('Coated earing-long', 'Miscellaneous', NULL, 3, 200),
('Coated earing-circular', 'Miscellaneous', NULL, NULL, NULL),
('Coated earing-loops', 'Miscellaneous', NULL, 2, NULL),
('Coated earing-extra large', 'Miscellaneous', NULL, 4, 70),
('Coated earing-medium', 'Miscellaneous', NULL, NULL, NULL),
('Coated earing-small', 'Miscellaneous', NULL, 14, NULL),
('Small gold earing', 'Miscellaneous', NULL, 2, NULL),
('Small silver earing', 'Miscellaneous', NULL, 3, 340),
('Normal fashion jewellery earing', 'Miscellaneous', NULL, 11, 810),
('LED watch', 'Miscellaneous', NULL, 4, 100),
('Apple sports watch', 'Miscellaneous', NULL, NULL, NULL),
('Anklet', 'Miscellaneous', NULL, NULL, NULL),
('Fashion jewellery', 'Miscellaneous', NULL, NULL, NULL);

-- Hats
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Black plain', 'Hats', NULL, 9, NULL),
('Grey', 'Hats', NULL, 4, NULL),
('Pink', 'Hats', NULL, 4, NULL),
('Red', 'Hats', NULL, 2, NULL),
('Yellow', 'Hats', NULL, 1, NULL),
('Baby pink', 'Hats', NULL, 4, NULL),
('White', 'Hats', NULL, 3, NULL),
('Bucket hat', 'Hats', NULL, 5, NULL),
('Woollen', 'Hats', NULL, 1, NULL),
('Tourist cape', 'Hats', NULL, 2, NULL),
('Pilot cape', 'Hats', NULL, NULL, NULL);

-- Net
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Green net', 'Net', NULL, 1, NULL),
('Blue', 'Net', NULL, 1, NULL),
('Red', 'Net', NULL, 3, NULL),
('Yellow', 'Net', NULL, 1, NULL);

-- Track Hat
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Purple', 'Track Hat', NULL, 1, NULL),
('Red', 'Track Hat', NULL, 1, NULL),
('Blue', 'Track Hat', NULL, 1, NULL),
('Black', 'Track Hat', NULL, 4, NULL),
('White/black', 'Track Hat', NULL, 0, NULL),
('Orange', 'Track Hat', NULL, 1, NULL),
('Sky blue', 'Track Hat', NULL, 2, NULL),
('Jungle green', 'Track Hat', NULL, 1, NULL),
('Baby pink', 'Track Hat', NULL, 4, NULL),
('Maroon', 'Track Hat', NULL, 1, NULL),
('Dark blue', 'Track Hat', NULL, 1, NULL),
('Beige', 'Track Hat', NULL, NULL, NULL);

-- Stand
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Plain standy', 'Stand', NULL, 2, 350),
('Stand with net', 'Stand', NULL, 3, 400),
('Standy 2 colours', 'Stand', NULL, 5, 400),
('Standy', 'Stand', NULL, 2, 300),
('Mix coloured cape', 'Stand', NULL, 1, 350),
('Girls cape', 'Stand', NULL, 1, NULL),
('Baby cape', 'Stand', NULL, 1, 100),
('Xmas cape', 'Stand', NULL, 2, 500),
('Wamama plaited kofia', 'Stand', NULL, 1, 300),
('White cap', 'Stand', NULL, 8, 350),
('Material with net', 'Stand', NULL, 4, 400),
('Kids cape', 'Stand', NULL, 4, 400),
('Mea culpa pink', 'Stand', NULL, 6, 400),
('Black&moti', 'Stand', NULL, 2, 400),
('Essential cape with gape', 'Stand', NULL, 1, 350),
('Essential cape without gape', 'Stand', NULL, 2, 350),
('C marvin', 'Stand', NULL, 2, 350),
('R marvin', 'Stand', NULL, 1, 350),
('Dior marvin', 'Stand', NULL, 3, 350),
('N&V marvin', 'Stand', NULL, 5, 350),
('Marvin with chuma', 'Stand', NULL, 2, 350),
('Marvin with prints', 'Stand', NULL, 2, 350),
('Mauzi heavy marvin', 'Stand', NULL, 1, 200),
('5 star marvin', 'Stand', NULL, 1, 200),
('OMG hair band', 'Stand', NULL, 3, NULL),
('Plain hair band', 'Stand', NULL, 1, 300),
('Plain smooth marvin', 'Stand', NULL, NULL, NULL),
('Kids muslim cape', 'Stand', NULL, NULL, NULL),
('Suspender', 'Stand', NULL, NULL, NULL);

-- Bras
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Dotted Bra Size 34', 'Dotted Bra', NULL, 1, 500),
('Dotted Bra Size 36', 'Dotted Bra', NULL, 2, 500),
('Dotted Bra Size 38', 'Dotted Bra', NULL, NULL, 500),
('Dotted Bra Size 40', 'Dotted Bra', NULL, NULL, 500),
('Dotted Bra Size 42', 'Dotted Bra', NULL, NULL, 500),
('Flowered Bra Size 34', 'Flowered Bra', NULL, NULL, 500),
('Flowered Bra Size 36', 'Flowered Bra', NULL, NULL, 500),
('Flowered Bra Size 38', 'Flowered Bra', NULL, 1, 500),
('Flowered Bra Size 40', 'Flowered Bra', NULL, 1, 500),
('Flowered Bra Size 42', 'Flowered Bra', NULL, NULL, NULL),
('Small Girl Size 32', 'Small Girl', NULL, 2, 300),
('Small Girl Size 34', 'Small Girl', NULL, 1, 300),
('Small Girl Size 36', 'Small Girl', NULL, 2, 300),
('Small Girl Size 38', 'Small Girl', NULL, NULL, 300),
('Small Girl Size 40', 'Small Girl', NULL, NULL, 300),
('Small Girl Size 42', 'Small Girl', NULL, NULL, 300),
('Fashion Bra Soft Size 32', 'Fashion Bra Soft', NULL, NULL, 500),
('Fashion Bra Soft Size 34', 'Fashion Bra Soft', NULL, NULL, 500),
('Fashion Bra Soft Size 36', 'Fashion Bra Soft', NULL, NULL, 500),
('Fashion Bra Soft Size 38', 'Fashion Bra Soft', NULL, 2, 500),
('Fashion Bra Soft Size 40', 'Fashion Bra Soft', NULL, NULL, 500),
('Fashion Bra Soft Size 42', 'Fashion Bra Soft', NULL, NULL, 500),
('Binny Bra with Strap Size 32', 'Binny Bra with Strap', NULL, NULL, 500),
('Binny Bra with Strap Size 34', 'Binny Bra with Strap', NULL, NULL, 500),
('Binny Bra with Strap Size 36', 'Binny Bra with Strap', NULL, NULL, 500),
('Binny Bra with Strap Size 38', 'Binny Bra with Strap', NULL, NULL, 500),
('Binny Bra with Strap Size 40', 'Binny Bra with Strap', NULL, 1, 500),
('Binny Bra with Strap Size 42', 'Binny Bra with Strap', NULL, 1, 500),
('Binny Normal Bra Size 32', 'Binny Normal Bra', NULL, NULL, 500),
('Binny Normal Bra Size 34', 'Binny Normal Bra', NULL, 2, 500),
('Binny Normal Bra Size 36', 'Binny Normal Bra', NULL, NULL, 500),
('Binny Normal Bra Size 38', 'Binny Normal Bra', NULL, NULL, 500),
('Binny Normal Bra Size 40', 'Binny Normal Bra', NULL, NULL, 500),
('Binny Normal Bra Size 42', 'Binny Normal Bra', NULL, NULL, 500),
('Binny Cup Bra Size 32', 'Binny Cup Bra', NULL, NULL, 600),
('Binny Cup Bra Size 34', 'Binny Cup Bra', NULL, NULL, 600),
('Binny Cup Bra Size 36', 'Binny Cup Bra', NULL, NULL, 600),
('Binny Cup Bra Size 38', 'Binny Cup Bra', NULL, 0, 600),
('Binny Cup Bra Size 40', 'Binny Cup Bra', NULL, NULL, 600),
('Binny Cup Bra Size 42', 'Binny Cup Bra', NULL, NULL, 600),
('Binny Cup Bra Size 46', 'Binny Cup Bra', NULL, 1, 600),
('Coppa 13 Bra Size 32', 'Coppa 13 Bra', NULL, NULL, NULL),
('Coppa 13 Bra Size 34', 'Coppa 13 Bra', NULL, NULL, NULL),
('Coppa 13 Bra Size 36', 'Coppa 13 Bra', NULL, NULL, NULL),
('Coppa 13 Bra Size 38', 'Coppa 13 Bra', NULL, NULL, NULL),
('Coppa 13 Bra Size 40', 'Coppa 13 Bra', NULL, NULL, NULL),
('Coppa 13 Bra Size 42', 'Coppa 13 Bra', NULL, NULL, NULL),
('Net Binny Bra Size 32', 'Net Binny Bra', NULL, NULL, 500),
('Net Binny Bra Size 34', 'Net Binny Bra', NULL, NULL, 500),
('Net Binny Bra Size 36', 'Net Binny Bra', NULL, NULL, 500),
('Net Binny Bra Size 38', 'Net Binny Bra', NULL, 2, 500),
('Net Binny Bra Size 40', 'Net Binny Bra', NULL, NULL, 500),
('Net Binny Bra Size 42', 'Net Binny Bra', NULL, NULL, 500),
('Silk Bra Size 32', 'Silk Bra', NULL, NULL, NULL),
('Silk Bra Size 34', 'Silk Bra', NULL, NULL, NULL),
('Silk Bra Size 36', 'Silk Bra', NULL, 1, NULL),
('Silk Bra Size 38', 'Silk Bra', NULL, NULL, NULL),
('Silk Bra Size 40', 'Silk Bra', NULL, NULL, NULL),
('Silk Bra Size 42', 'Silk Bra', NULL, NULL, NULL),
('Clear bra straps', 'Silk Bra', NULL, NULL, NULL),
('Tops with teddy bear', 'Tops', NULL, 12, 150),
('Cotton tops', 'Tops', NULL, 6, 200),
('Bandana', 'Tops', NULL, 9, 50);

-- Panties
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Women high waist', 'Panties', NULL, 8, 250),
('Women cotton', 'Panties', NULL, 11, 250),
('Cotton flower', 'Panties', NULL, 4, 250),
('Honadi cotton', 'Panties', NULL, 3, 250),
('With flowers', 'Panties', NULL, 3, 250),
('Voronin net', 'Panties', NULL, 5, 250),
('Hot pant net', 'Panties', NULL, 2, 250),
('Plain seamless', 'Panties', NULL, 4, 250),
('Plain bikini seamless', 'Panties', NULL, 1, 200),
('Vimerleas.bikini &net', 'Panties', NULL, 2, 200),
('Seamless with net', 'Panties', NULL, 11, 200),
('Net and cotton', 'Panties', NULL, 4, 250),
('Happy boy boxers', 'Panties', NULL, 6, 50),
('Wamika baby boxers', 'Panties', NULL, 6, 100);

-- Balls
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Rough hard', 'Balls', NULL, 2, 300),
('Baby small', 'Balls', NULL, 2, 200),
('Big with tube', 'Balls', NULL, 3, 400),
('Smooth hard', 'Balls', NULL, 4, 350);

-- Umbrella
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Kids', 'Umbrella', NULL, 3, 350),
('Floral', 'Umbrella', NULL, 3, 350),
('Black plain', 'Umbrella', NULL, 1, 350),
('Plastic', 'Umbrella', NULL, 2, 400),
('With handle', 'Umbrella', NULL, 1, 600),
('Checked', 'Umbrella', NULL, 1, NULL),
('Blue and white', 'Umbrella', NULL, 1, NULL),
('Umbrella', 'Umbrella', NULL, 2, 250);

-- Key Holder
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Key chain', 'Key Holder', NULL, 8, 50),
('Shoe', 'Key Holder', NULL, 2, 100),
('Rubber', 'Key Holder', NULL, 2, 250),
('Water', 'Key Holder', NULL, 2, 250),
('Bead', 'Key Holder', NULL, 4, 50);

-- Electronics
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Type C cables-punex', 'Electronics', NULL, 2, 200),
('Tecno earphones', 'Electronics', NULL, 1, NULL),
('Sony earphones', 'Electronics', NULL, 1, 150),
('Type C USB data cable', 'Electronics', NULL, 2, 100),
('Selfie stick', 'Electronics', NULL, 1, 1300),
('Headphone with mic', 'Electronics', NULL, 1, 1500);

-- Watches
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('V bely watch', 'Watches', NULL, 1, 500),
('Stainless', 'Watches', NULL, 1, 300),
('Star wrist', 'Watches', NULL, 1, 400),
('Rectangle wrist', 'Watches', NULL, 1, NULL),
('Red rectangle', 'Watches', NULL, 1, NULL),
('vanDRoss', 'Watches', NULL, 1, 700),
('Silver', 'Watches', NULL, 1, NULL),
('Rectangle gold', 'Watches', NULL, 4, 750),
('Wamba circular', 'Watches', NULL, 2, NULL);

-- Ice Watch
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Original silver', 'Ice Watch', NULL, 1, 1600),
('Silver', 'Ice Watch', NULL, 3, 800),
('Gold', 'Ice Watch', NULL, 1, 800),
('Ladies magnet', 'Ice Watch', NULL, 2, 400),
('Ladies gold', 'Ice Watch', NULL, 1, 400),
('Ladies silver', 'Ice Watch', NULL, 1, 400);

-- Kids Watch
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Kid watch', 'Kids Watch', NULL, 4, 50),
('Y16', 'Kids Watch', NULL, 6, 60),
('Y130', 'Kids Watch', NULL, 5, 100),
('T02', 'Kids Watch', NULL, 6, 100),
('Light watch', 'Kids Watch', NULL, 6, 150),
('Sport-big', 'Kids Watch', NULL, 6, 300),
('Sport-medium', 'Kids Watch', NULL, 6, 250),
('Sport-small', 'Kids Watch', NULL, 6, 200);

-- Ladies Watch
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Oval shape', 'Ladies Watch', NULL, 4, 300),
('Love shiny', 'Ladies Watch', NULL, 1, 300),
('Rectangle shiny', 'Ladies Watch', NULL, 1, 300),
('Rectangle shape', 'Ladies Watch', NULL, 5, 300),
('Small square', 'Ladies Watch', NULL, 5, 300),
('Circle shape', 'Ladies Watch', NULL, 6, 300),
('Pearl chain black', 'Ladies Watch', NULL, 2, 100),
('Pearl black and white', 'Ladies Watch', NULL, 2, 100),
('Pearl white', 'Ladies Watch', NULL, 1, 100),
('Pearl chain long', 'Ladies Watch', NULL, 1, NULL),
('Louis Vuitton', 'Ladies Watch', NULL, 1, NULL),
('Ras pic', 'Ladies Watch', NULL, 1, NULL),
('King', 'Ladies Watch', NULL, 1, NULL),
('WCB', 'Ladies Watch', NULL, 1, NULL),
('God bless', 'Ladies Watch', NULL, 1, NULL),
('White pearl necklace', 'Ladies Watch', NULL, NULL, NULL),
('Label chain', 'Ladies Watch', NULL, 1, 300),
('Apple', 'Ladies Watch', NULL, 1, 300),
('Star', 'Ladies Watch', NULL, 1, 250),
('4 hearts', 'Ladies Watch', NULL, NULL, NULL),
('Waist belt', 'Ladies Watch', NULL, NULL, NULL);

-- Bracelet
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Silver ice chain', 'Bracelet', NULL, 1, 1500),
('Gold ice', 'Bracelet', NULL, 1, 1000),
('Silver', 'Bracelet', NULL, 2, 500);

-- Chain
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Couple', 'Chain', NULL, 10, 200),
('Label', 'Chain', NULL, NULL, NULL),
('23', 'Chain', NULL, 1, 300),
('Mask', 'Chain', NULL, 1, 300),
('Liverpool', 'Chain', NULL, 1, 300),
('Shoe', 'Chain', NULL, 1, 300),
('Whister', 'Chain', NULL, 1, 300),
('Pattern gold', 'Chain', NULL, 11, 150),
('Dotted gold', 'Chain', NULL, 10, 150),
('Roller silver', 'Chain', NULL, 5, NULL),
('Roller gold', 'Chain', NULL, 2, NULL),
('Simple gold', 'Chain', NULL, 1, 100),
('Gold chain', 'Chain', NULL, 21, 200),
('Silver long', 'Chain', NULL, 7, NULL),
('Silver medium', 'Chain', NULL, 3, 200),
('Silver short', 'Chain', NULL, 1, 350),
('Gold long', 'Chain', NULL, NULL, NULL);

-- Bathing Object
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Gloves', 'Bathing Object', NULL, 1, 100),
('Long scrub', 'Bathing Object', NULL, 0, 150),
('Sponge', 'Bathing Object', NULL, 3, NULL),
('Plain hair band', 'Bathing Object', NULL, 6, 30),
('Flower hairband', 'Bathing Object', NULL, 11, 50);

-- Miscellaneous Bathing Objects
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Graduation banner', 'Miscellaneous Bathing Objects', NULL, 2, NULL),
('Big chain', 'Miscellaneous Bathing Objects', NULL, 1, 300),
('Valentine basket', 'Miscellaneous Bathing Objects', NULL, 3, 100),
('Double nail cutter', 'Miscellaneous Bathing Objects', NULL, 2, 100),
('Small mirror', 'Miscellaneous Bathing Objects', NULL, 3, 50),
('Plastic comb', 'Miscellaneous Bathing Objects', NULL, 1, 50),
('Metal comb', 'Miscellaneous Bathing Objects', NULL, 1, 50),
('Jelly comb', 'Miscellaneous Bathing Objects', NULL, 1, 50),
('Brush comb', 'Miscellaneous Bathing Objects', NULL, 2, NULL),
('Girl fan', 'Miscellaneous Bathing Objects', NULL, 1, 1500),
('Beauty cosmetic bag', 'Miscellaneous Bathing Objects', NULL, 5, NULL),
('Big bead necklace', 'Miscellaneous Bathing Objects', NULL, 1, NULL),
('Earpods poach', 'Miscellaneous Bathing Objects', NULL, 2, NULL),
('Horn shaped necklace', 'Miscellaneous Bathing Objects', NULL, 3, NULL),
('Double necklace', 'Miscellaneous Bathing Objects', NULL, 2, NULL),
('Waistbeads', 'Miscellaneous Bathing Objects', NULL, 2, NULL),
('Bead anklet', 'Miscellaneous Bathing Objects', NULL, 3, 300),
('Metal chain', 'Miscellaneous Bathing Objects', NULL, 6, NULL),
('Ras Africa chains', 'Miscellaneous Bathing Objects', NULL, 3, NULL),
('Forever bead necklace', 'Miscellaneous Bathing Objects', NULL, 1, NULL),
('Gillette', 'Miscellaneous Bathing Objects', NULL, 2, 200),
('Pencil poach big', 'Miscellaneous Bathing Objects', NULL, 1, NULL),
('Pencil poach small', 'Miscellaneous Bathing Objects', NULL, 4, 300),
('Xmas decoration', 'Miscellaneous Bathing Objects', NULL, 2, NULL),
('Men tie', 'Miscellaneous Bathing Objects', NULL, 1, NULL),
('Women dolly bag', 'Miscellaneous Bathing Objects', NULL, NULL, NULL),
('Gift bag', 'Miscellaneous Bathing Objects', NULL, NULL, NULL);

-- Gum Boots
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Size 25', 'Gum Boots', NULL, 1, NULL),
('Size 31', 'Gum Boots', NULL, 1, NULL),
('Size 33', 'Gum Boots', NULL, 1, NULL),
('Size 36', 'Gum Boots', NULL, 1, NULL);

-- House Shoe
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Size 38', 'House Shoe', NULL, 2, NULL),
('Size 40', 'House Shoe', NULL, 3, NULL),
('Size 44', 'House Shoe', NULL, 1, NULL);

-- Crazy Colour
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('5/66', 'Crazy Colour', NULL, NULL, 60),
('6/45', 'Crazy Colour', NULL, 5, 60),
('0/45', 'Crazy Colour', NULL, 4, 60),
('0/33', 'Crazy Colour', NULL, 4, 60),
('7/4', 'Crazy Colour', NULL, 5, 60),
('0/43', 'Crazy Colour', NULL, 5, 60),
('7/45', 'Crazy Colour', NULL, 5, 60),
('0/22', 'Crazy Colour', NULL, 5, 60),
('6/66', 'Crazy Colour', NULL, 5, 60),
('0/00', 'Crazy Colour', NULL, NULL, 60),
('9/43', 'Crazy Colour', NULL, 3, 60),
('9/45', 'Crazy Colour', NULL, 3, 60),
('9/33', 'Crazy Colour', NULL, 2, 60),
('8/45', 'Crazy Colour', NULL, 3, 60),
('8/22', 'Crazy Colour', NULL, NULL, 60),
('4/66', 'Crazy Colour', NULL, 5, 60),
('5/45', 'Crazy Colour', NULL, 4, 60),
('5/45', 'Crazy Colour', NULL, 5, 60),
('0/64', 'Crazy Colour', NULL, 4, 60),
('7/66', 'Crazy Colour', NULL, 4, 60),
('0/88', 'Crazy Colour', NULL, NULL, NULL);

-- Miscellaneous Items (Continued)
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Hot colour lipsticks', 'Miscellaneous', NULL, 6, 50),
('Face mask-blue', 'Miscellaneous', NULL, 43, 10),
('Face mask-black', 'Miscellaneous', NULL, 37, 10),
('Coated earings', 'Miscellaneous', NULL, 9, 150),
('Nap cards', 'Miscellaneous', NULL, 11, 30),
('Soft stripped handkerchief', 'Miscellaneous', NULL, 24, 30),
('Handkerchief', 'Miscellaneous', NULL, 5, 50),
('Pere carting handkerchief', 'Miscellaneous', NULL, 9, 30),
('Handkerchief', 'Miscellaneous', NULL, 1, 200),
('Soft face towels', 'Miscellaneous', NULL, 2, 200),
('Silk head scarf', 'Miscellaneous', NULL, 2, 200),
('Fishnet', 'Miscellaneous', NULL, 8, 50),
('Lady fashion fishnet', 'Miscellaneous', NULL, NULL, 100),
('Fishnet socks', 'Miscellaneous', NULL, 5, 100),
('Irene lipsticks', 'Miscellaneous', NULL, NULL, 100),
('Men stud earing', 'Miscellaneous', NULL, 2, 1000),
('Silver', 'Miscellaneous', NULL, 4, 550),
('Black', 'Miscellaneous', NULL, 2, 1000),
('Raincoat-adult', 'Miscellaneous', NULL, 2, 200),
('Kids-normal', 'Miscellaneous', NULL, NULL, NULL),
('Kids-spiderman', 'Miscellaneous', NULL, NULL, NULL),
('Tancho hairdye', 'Miscellaneous', NULL, NULL, NULL),
('2-4 years', 'Miscellaneous', NULL, 1, 200),
('6-8years', 'Miscellaneous', NULL, 4, 200),
('8-10years', 'Miscellaneous', NULL, 4, 200),
('10-12years', 'Miscellaneous', NULL, 1, 200);

-- Red Stockings
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('2-4years', 'Red Stockings', NULL, 1, 200),
('6-8years', 'Red Stockings', NULL, 2, 200),
('8-10years', 'Red Stockings', NULL, 2, 200),
('10-12years', 'Red Stockings', NULL, NULL, 200);

-- White Stockings
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('2-4years', 'White Stockings', NULL, NULL, 200),
('6-8years', 'White Stockings', NULL, NULL, 200),
('8-10years', 'White Stockings', NULL, 1, 200),
('10-12 years', 'White Stockings', NULL, 2, 200);

-- Mixed Colour Stockings
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Mixed', 'Mixed Colour Stockings', NULL, 7, 150);

-- Socks
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Kids socks', 'Socks', NULL, 29, 50),
('Kids school socks(white)', 'Socks', NULL, 12, 50),
('Men socks long', 'Socks', NULL, 19, 100),
('Nike black long socks', 'Socks', NULL, 12, NULL),
('Ankle socks', 'Socks', NULL, 14, 50),
('Men boxer', 'Socks', NULL, 2, NULL),
('Lai3 fat underwear', 'Socks', NULL, 2, 500),
('Victan 3in1', 'Socks', NULL, 1, 500),
('Safi boy 3in1', 'Socks', NULL, 4, 150),
('White man 3in1', 'Socks', NULL, 9, 500);

-- Handbags
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Leather bag-brown', 'Handbags', NULL, 1, 2000),
('Leather bag-white', 'Handbags', NULL, 1, 2000),
('Leather bag-black', 'Handbags', NULL, 1, 2000),
('Checked handbag', 'Handbags', NULL, 1, 2000),
('Plain white', 'Handbags', NULL, 1, 1500),
('Traditional', 'Handbags', NULL, 1, 2000),
('Louis Vuitton waist bag', 'Handbags', NULL, 1, 1500),
('Sisal knitted', 'Handbags', NULL, 1, NULL),
('O labelled bags', 'Handbags', NULL, NULL, 1800),
('Red', 'Handbags', NULL, 1, 1800),
('Peach', 'Handbags', NULL, 1, 2000),
('White and black', 'Handbags', NULL, 1, 1800),
('Slanted', 'Handbags', NULL, 1, 1800),
('Jungle green', 'Handbags', NULL, 2, 1500),
('Chanel', 'Handbags', NULL, 2, 2000),
('College bag', 'Handbags', NULL, 3, 1000),
('Sling bag', 'Handbags', NULL, 4, 200),
('Women hand bag', 'Handbags', NULL, 3, 1500),
('Chest bag', 'Handbags', NULL, 2, 1500),
('Men Sling bag', 'Handbags', NULL, 1, 1000),
('Sports bag', 'Handbags', NULL, 2, NULL),
('Rose mand hand bag', 'Handbags', NULL, NULL, NULL),
('Baby clinic bag', 'Handbags', NULL, NULL, NULL);

-- Miscellaneous Items (Continued)
INSERT INTO closet (name, category, quantity, amount, price) VALUES
('Rubberbands', 'Miscellaneous', NULL, 0, 30),
('Ornament china', 'Miscellaneous', NULL, 8, 50),
('Anti blue light glasses', 'Miscellaneous', NULL, 6, 500),
('Clear', 'Glasses', NULL, 14, 200),
('Brown', 'Glasses', NULL, 7, 200),
('Black', 'Glasses', NULL, 4, 200),
('Pink', 'Glasses', NULL, NULL, NULL),
('Ice', 'Belts', NULL, 2, 1500),
('Men', 'Belts', NULL, 11, 200),
('Ladies', 'Belts', NULL, 1, 200),
('Ladies small', 'Belts', NULL, 11, 100),
('Kenya flag', 'Belts', NULL, 2, NULL),
('Stomach', 'Belts', NULL, 2, 1500),
('Official plain', 'Tops', NULL, 8, 1000),
('Official striped', 'Tops', NULL, 5, 1000),
('Crochet cover', 'Tops', NULL, 2, 800),
('Flannel', 'Tops', NULL, 6, 1000),
('Heavy flannel', 'Tops', NULL, 5, 1500),
('Normal shirt', 'Tops', NULL, 9, 750),
('Silk off shoulder', 'Tops', NULL, 5, 1000),
('Flower tops', 'Tops', NULL, 3, 500),
('Jersey baseball', 'Tops', NULL, 12, 1000),
('Crop baseball', 'Tops', NULL, 7, 1000),
('Nike stripped', 'Tops', NULL, 2, 1000),
('Crop with chain', 'Tops', NULL, 4, 500),
('Mashimo tops', 'Tops', NULL, 3, 1000),
('Bra tops', 'Tops', NULL, 2, 500),
('Brazil', 'Tops', NULL, 4, 750),
('Puma', 'Tops', NULL, 11, 500),
('Girls vest', 'Tops', NULL, 4, 1200),
('Thrasher', 'Tops', NULL, 8, 1000),
('Long official', 'Tops', NULL, 4, 750),
('Off tops', 'Tops', NULL, 3, NULL),
('Pullnecks backless', 'Tops', NULL, NULL, NULL),
('Man city home', 'Jersey', NULL, 2, NULL),
('Man united home', 'Jersey', NULL, 1, NULL),
('Chelsea', 'Jersey', NULL, 4, NULL),
('Liverpool', 'Jersey', NULL, 4, NULL),
('Man united-3rd kit', 'Jersey', NULL, 3, NULL),
('Arsenal away', 'Jersey', NULL, 2, NULL),
('Arsenal home', 'Jersey', NULL, 3, NULL),
('Men pullneck', 'Jersey', NULL, 3, NULL),
('Men shirt-3 buttons', 'Jersey', NULL, 6, NULL),
('Lhuo ladies shirt', 'Jersey', NULL, 2, NULL),
('Ladies shirt with jeans', 'Jersey', NULL, 2, NULL),
('Ladies mauzi shirt', 'Jersey', NULL, 4, NULL),
('Mauzi sweater', 'Jersey', NULL, 3, NULL),
('Mauzi sweater evop', 'Jersey', NULL, 3, NULL),
('Arc fast white-men shirt', 'Jersey', NULL, 1, NULL),
('Arc fast black-men shirt', 'Jersey', NULL, 1, NULL),
('Rhode men shirt', 'Jersey', NULL, 3, NULL),
('Men official shirt', 'Jersey', NULL, 4, NULL),
('Amiri mauzi top', 'Jersey', NULL, 1, NULL),
('2 black round neck shirt', 'Jersey', NULL, 2, NULL),
('LV sport shirt-men', 'Jersey', NULL, 1, NULL),
('Lakers 23 mashimo', 'Jersey', NULL, 2, NULL),
('Baby naked wolf shirt', 'Jersey', NULL, 3, NULL),
('Crop with flower', 'Jersey', NULL, 6, NULL),
('Sports bra', 'Jersey', NULL, 3, NULL),
('Plain body suit', 'Jersey', NULL, 4, NULL),
('Body suit-glitters', 'Jersey', NULL, 3, NULL),
('Ring tops', 'Jersey', NULL, 3, NULL),
('36shirts men', 'Jersey', NULL, 3, NULL),
('Cotton shirts', 'Jersey', NULL, NULL, NULL),
('Denim Skirts Size 27', 'Denim Skirts', NULL, NULL, NULL),
('Denim Skirts Size 28', 'Denim Skirts', NULL, 1, NULL),
('Denim Skirts Size 30', 'Denim Skirts', NULL, 1, NULL),
('Denim Skirts Size 32', 'Denim Skirts', NULL, NULL, NULL),
('Denim Skirts Size 34', 'Denim Skirts', NULL, 1, NULL),
('Denim Skirts Size 36', 'Denim Skirts', NULL, NULL, NULL),
('Denim Skirts Size 27', 'Denim Skirts', NULL, 1, 1500),
('Denim Skirts Size 28', 'Denim Skirts', NULL, 1, 1500),
('Denim Skirts Size 30', 'Denim Skirts', NULL, 2, 1500),
('Denim Skirts Size 32', 'Denim Skirts', NULL, 3, 1500),
('Denim Skirts Size 34', 'Denim Skirts', NULL, NULL, 1500),
('Material Official Skirt 14', 'Material Official Skirt', NULL, 1, 1000),
('Material Official Skirt 16', 'Material Official Skirt', NULL, 2, 1000),
('Material Official Skirt 10', 'Material Official Skirt', NULL, 1, 1000),
('Leather Skirts XL', 'Leather Skirts', NULL, 1, 1000),
('Leather Skirts L', 'Leather Skirts', NULL, 1, 1000),
('Leather Skirts 2XL', 'Leather Skirts', NULL, 1, 1000),
('Jeans Skirt 34', 'Jeans Skirt', NULL, 2, 1250),
('Jeans Skirt 32', 'Jeans Skirt', NULL, 2, 1250),
('Jeans Skirt 30', 'Jeans Skirt', NULL, 2, 1250),
('Jeans Skirt 28', 'Jeans Skirt', NULL, 2, 1250),
('Jeans Skirt 27', 'Jeans Skirt', NULL, 2, 1250),
('Flower 2 Piece Top & Skirt', '2 Piece Top & Skirt', NULL, 4, 1400),
('Checked 2 Piece Top & Skirt', '2 Piece Top & Skirt', NULL, 4, 1500),
('Woollen long 2 Piece Top & Skirt', '2 Piece Top & Skirt', NULL, 5, 1800),
('Glitter 2 Piece Top & Skirt', '2 Piece Top & Skirt', NULL, 3, NULL),
('Rainbow 2 Piece Top & Skirt', '2 Piece Top & Skirt', NULL, 2, 1500),
('Chain top and skirt', '2 Piece Top & Skirt', NULL, 1, NULL),
('Luhao 2 piece', '2 Piece Top & Skirt', NULL, 2, NULL),
('Bikini top 2 piece', '2 Piece Top & Skirt', NULL, 2, NULL),
('Tea cup 2 piece', '2 Piece Top & Skirt', NULL, 1, NULL),
('Ombre skirt pink and black', '2 Piece Top & Skirt', NULL, NULL, NULL),
('Velvet long maxi', 'Dresses', NULL, 2, 1000),
('Nylon maxi', 'Dresses', NULL, 5, 1800),
('Mauzi dress and sweater', 'Dresses', NULL, 1, NULL),
('Leather', 'Dresses', NULL, 3, 1550),
('Checked', 'Dresses', NULL, 1, 1500),
('Nylon short', 'Dresses', NULL, 2, 1400),
('Shinny', 'Dresses', NULL, 2, 1500),
('Leather short', 'Dresses', NULL, 1, NULL),
('Stripped(mgongo wazi)', 'Dresses', NULL, 3, NULL),
('Lisa wong soft official', 'Dresses', NULL, 3, 2000),
('Chettah dress', 'Dresses', NULL, 7, 1500),
('Shirt dress', 'Dresses', NULL, 2, NULL),
('Flower wamama dress', 'Dresses', NULL, NULL, NULL),
('Cotton long', 'Dresses', NULL, NULL, NULL),
('Cotton short', 'Dresses', NULL, 1, 1500),
('Purple stringed', 'Dresses', NULL, 1, 1500),
('1+1 gaped', 'Dresses', NULL, NULL, NULL),
('Cotton maroon mgongo wazi and black', 'Dresses', NULL, 4, 1800),
('2 piece nyororo', 'Dresses', NULL, NULL, 1800),
('Maxi dress', 'Dresses', NULL, 1, 200),
('Flower maxi', 'Dresses', NULL, 1, 1500),
('Neti long dress', 'Dresses', NULL, 3, 1500),
('Mkunjo dress blue', 'Dresses', NULL, 2, 1500),
('1+1 maroon gold shoulder', 'Dresses', NULL, NULL, NULL),
('Nylon orange', 'Dresses', NULL, 3, 1700),
('Many stringed dress', 'Dresses', NULL, NULL, 1500),
('One handed', 'Dresses', NULL, 1, 1300),
('Official with long bow tie', 'Dresses', NULL, 5, 1500),
('Coloured light', 'Dresses', NULL, 3, 1300),
('Sun dress short', 'Dresses', NULL, 3, 1500),
('Sun dress long', 'Dresses', NULL, 3, 1500),
('Chain dress', 'Dresses', NULL, 2, 1500),
('Sun dress flowered long dress', 'Dresses', NULL, 1, 1300),
('Snake print', 'Dresses', NULL, 3, 1800),
('Rainbow coloured', 'Dresses', NULL, 1, 1500),
('Shoulder less', 'Dresses', NULL, 5, 1800),
('Bead at the back', 'Dresses', NULL, 7, NULL),
('Glitters with slit-long', 'Dresses', NULL, 2, NULL),
('Checked usa official', 'Dresses', NULL, 3, 1500),
('Collared official', 'Dresses', NULL, 3, 1500),
('Short dress', 'Dresses', NULL, 1, NULL),
('Off shoulder long', 'Dresses', NULL, 2, NULL),
('Bowed light blazes', 'Dresses', NULL, 2, NULL),
('Maxi short', 'Dresses', NULL, 1, NULL),
('Stripped-short', 'Dresses', NULL, 1, NULL),
('Chik fashion maxi', 'Dresses', NULL, 1, NULL),
('Top flowered', 'Dresses', NULL, 1, NULL),
('Maroon plain', 'Dresses', NULL, 2, NULL),
('Gucci', 'Dresses', NULL, 3, NULL),
('Wei long-pink', 'Dresses', NULL, 1, NULL),
('Luhao dress', 'Dresses', NULL, 1, NULL),
('Stripped long', 'Dresses', NULL, 1, NULL),
('Mgongo wazi stripped', 'Dresses', NULL, 2, NULL),
('Many coloured', 'Dresses', NULL, NULL, NULL),
('Simple striped', 'Dresses', NULL, NULL, NULL),
('Coloured long', 'Dresses', NULL, NULL, NULL),
('Cleary rain', 'Dresses', NULL, NULL, NULL),
('Peried-long', 'Dresses', NULL, NULL, NULL),
('Long pink', 'Dresses', NULL, NULL, NULL),
('Stripped jumpsuit-top', 'Official Suit', NULL, 4, 1800),
('Plain jumpsuit', 'Official Suit', NULL, 3, 1700),
('Stripped jumpsuit', 'Official Suit', NULL, 3, 1700),
('L', 'Official Suit', NULL, 5, 1500),
('XL', 'Official Suit', NULL, 2, 1500),
('M', 'Official Suit', NULL, 3, 1500),
('Gym set', 'Official Suit', NULL, 7, 1500),
('Lucky label jumpsuit', 'Official Suit', NULL, 2, 1200),
('California 2pc', 'Trousers', NULL, 2, 1800),
('Mauzi 2pc', 'Trousers', NULL, 1, 1800),
('Palm angels 2pc', 'Trousers', NULL, 1, 1500),
('Gucci', 'Trousers', NULL, 1, 1800),
('Fendi', 'Trousers', NULL, 1, NULL),
('Luhao', 'Trousers', NULL, 1, 2000),
('Naked', 'Trousers', NULL, 1, NULL),
('M.suspender', 'Trousers', NULL, 1, NULL),
('Pocket', 'Trousers', NULL, 3, NULL),
('Striped', 'Trousers', NULL, 2, NULL),
('Off shoulder', 'Trousers', NULL, 1, NULL),
('Dior', 'Trousers', NULL, 1, NULL),
('Ombre', 'Trousers', NULL, 2, NULL),
('Alice fashion', 'Trousers', NULL, 1, NULL),
('Flowered', 'Trousers', NULL, 1, NULL),
('Balenciaga', 'Trousers', NULL, 1, NULL),
('Adidas', 'Trousers', NULL, NULL, NULL),
('Luhao 2pc', 'Shorts', NULL, 4, 2000),
('Teddy 2pc', 'Shorts', NULL, 1, 1500),
('Ombre short', 'Shorts', NULL, 2, NULL),
('L pertan short', 'Shorts', NULL, 1, NULL),
('Play boy 2pc', 'Shorts', NULL, 1, NULL),
('Fendi 2pc', 'Shorts', NULL, 2, 1500),
('Velvet short 2pc', 'Shorts', NULL, 3, 1500),
('FG 2pc short', 'Shorts', NULL, 1, 1500),
('Naked wolf short', 'Shorts', NULL, 1, 1500),
('Gallery dept', 'Shorts', NULL, NULL, NULL),
('Mkunjo trousers', 'Shorts', NULL, 2, NULL),
('Dotted adult skintight', 'Shorts', NULL, 1, NULL),
('Gold print skintight', 'Shorts', NULL, 1, NULL),
('Starry fashion', 'Shorts', NULL, 1, NULL),
('Palazzo', 'Shorts', NULL, 1, 700),
('Hipstar pink', 'Shorts', NULL, 1, 700),
('Alice fashion', 'Shorts', NULL, 1, NULL),
('Naked wolf', 'Shorts', NULL, NULL, NULL),
('Track 2pc', 'Shorts', NULL, 1, NULL),
('Essential 2pc', 'Shorts', NULL, 1, NULL),
('Adidas 2pc', 'Shorts', NULL, NULL, NULL),
('Miu miu 3pc', 'Shorts', NULL, 3, 1800),
('Side pocket 3pc', 'Shorts', NULL, 2, 1800),
('Track 3 pc', 'Shorts', NULL, 2, 1800),
('LA track 3pc', 'Shorts', NULL, 1, 1800),
('LA sidepocket 3pc', 'Shorts', NULL, 1, 1800),
('SNX sport bag', 'Bags', NULL, 2, NULL),
('Cube B sport bag', 'Bags', NULL, 1, NULL),
('Travelling', 'Bags', NULL, 1, NULL),
('Mauzi hand bag', 'Bags', NULL, 1, NULL),
('College jacket B crop', 'Jacket', NULL, 4, 1800),
('College jacket leather', 'Jacket', NULL, 1, 2000),
('College jacket plain', 'Jacket', NULL, 3, 1500),
('College 23 crop jacket', 'Jacket', NULL, 3, 2000),
('Black leather', 'Jacket', NULL, 2, 2000),
('Denim crop', 'Jacket', NULL, 2, 2000),
('Denim long', 'Jacket', NULL, 2, NULL),
('Decorated red and blue', 'Jacket', NULL, 4, NULL),
('Jeep black', 'Jacket', NULL, 1, NULL),
('Wamama checked', 'Jacket', NULL, 2, NULL),
('Basha jacket', 'Jacket', NULL, 1, 1600),
('Bomber', 'Jacket', NULL, 5, 1200),
('Wool sweater', 'Jacket', NULL, 8, 1000),
('College jacket', 'Jacket', NULL, 1, 1500),
('P double sweater', 'Jacket', NULL, 1, 1800),
('Creative college jacket', 'Jacket', NULL, 7, 1300),
('Kids track suit', 'Jacket', NULL, 3, NULL),
('Kids jeans suit', 'Jacket', NULL, 2, NULL),
('Grey kids jeans', 'Jacket', NULL, 1, NULL),
('Black small kids jeans', 'Jacket', NULL, NULL, NULL),
('Kids balenciaga', 'Jacket', NULL, NULL, NULL),
('Jeans kids', 'Jacket', NULL, 1, 1000),
('Naked wolf', 'Jacket', NULL, NULL, 550),
('FUGO', 'Jacket', NULL, 1, NULL),
('Balenciaga', 'Jacket', NULL, 1, 550),
('Amiri', 'Jacket', NULL, 2, 550),
('V label shirt', 'Jacket', NULL, 2, 550),
('XL shirt', 'Jacket', NULL, 2, 550),
('Kids denim shirt', 'Jacket', NULL, 1, NULL),
('Boothy short', 'Jacket', NULL, 11, 500),
('Nike sweat short', 'Jacket', NULL, 4, NULL),
('Jean short', 'Jacket', NULL, 1, NULL),
('Size 27', 'Jacket', NULL, 1, NULL),
('Biker short', 'Jacket', NULL, 1, 1000),
('Leather cargo pant L', 'Jacket', NULL, 1, NULL),
('Leather cargo pant M', 'Jacket', NULL, 1, NULL),
('Leather trouser', 'Jacket', NULL, NULL, NULL),
('Combat material', 'Jacket', NULL, NULL, NULL),
('Combat Jeans', 'Jacket', NULL, NULL, NULL),
('Size 30', 'Jacket', NULL, NULL, NULL),
('Size 28', 'Jacket', NULL, NULL, NULL),
('Soft Khaki 38', 'Soft Khaki', NULL, 1, NULL),
('Soft Khaki 36', 'Soft Khaki', NULL, 1, NULL),
('Soft Khaki 32', 'Soft Khaki', NULL, 1, NULL),
('Men Jeans 27', 'Men Jeans', NULL, NULL, 1500),
('Men Jeans 28', 'Men Jeans', NULL, NULL, 1500),
('Men Jeans 30', 'Men Jeans', NULL, NULL, 1500),
('Men Jeans 32', 'Men Jeans', NULL, 1, 1500),
('Men Jeans 34', 'Men Jeans', NULL, 1, 1500),
('Men Jeans 36', 'Men Jeans', NULL, 1, 1500),
('Nike trouser men', 'Men Jeans', NULL, 1, NULL),
('Balenciaga cargo(L)', 'Men Jeans', NULL, 1, NULL),
('Balenciaga cargo(M)', 'Men Jeans', NULL, 1, NULL),
('Stripped crops', 'Men Jeans', NULL, 3, NULL),
('Maasai shuka', 'Men Jeans', NULL, 2, 1000),
('Arfat', 'Men Jeans', NULL, 1, 500),
('Vikoi', 'Men Jeans', NULL, NULL, 1000),
('Leso', 'Men Jeans', NULL, 3, 500),
('Small', 'School Bags', NULL, 2, 500),
('Leather', 'School Bags', NULL, 1, 1500),
('Black boys', 'School Bags', NULL, 1, 1000),
('Pink girls', 'School Bags', NULL, 1, 1000),
('Small leather', 'School Bags', NULL, 1, NULL),
('Vaseline Solid Oil cocoa butter', 'Vaseline Solid Oil', NULL, 240, 1, 400),
('Vaseline Solid Oil', 'Vaseline Solid Oil', NULL, 240, 1, 400),
('Eye pencil', 'Miscellaneous', NULL, 27, 30),
('Foundation', 'Miscellaneous', NULL, 2, NULL),
('Wallet', 'Miscellaneous', NULL, 2, NULL);
